function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "1K85YoP5VJtxoR-Jd-_u1jGCYvRTkuwBpfri551xUTVQ"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.companyName || "",
      data.industry || "",
      data.yourName || "",
      data.position || "",
      data.email || "",
      data.phone || "",
      data.companyTypes ? data.companyTypes.join(", ") : "", // Multiple checkboxes
      data.interests || "",
      data.meetingPreference || "",
      data.additionalInfo || "",
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "success",
        message: "B2B registration submitted!",
      })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in B2B Form doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "B2B registration failed: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}

/* 
Google Sheet Headers (Row 1):
Timestamp | Company Name | Industry | Your Name | Position | Email | Phone | Company Types | Interests | Meeting Preference | Additional Info

Deploy Settings:
- Execute as: Me
- Who has access: Anyone
- Copy the deployment URL and replace YOUR_B2B_APPS_SCRIPT_URL in the JavaScript
*/
